-- Free_Speech.lua
-- Author: Machiavelli
-- DateCreated: 6/1/2012 7:39:17 AM
--------------------------------------------------------------
function GiveBirthPlaceBuilding(playerID, unitID, hexVec, unitType, cultureType, civID, primaryColor, secondaryColor, unitFlagIndex, fogState, selected, military, notInvisible)
	local player = Players[playerID];
	local unit = player:GetUnitByID(unitID);
	local policyID = GameInfoTypes["POLICY_FREE_SPEECH"];
	local plot = unit:GetPlot();

	-- Only give the birthplace if the player has the policy and this is a great person spawned in a city
	if(player:HasPolicy(policyID) and not player:IsPolicyBlocked(policyID) and unit:IsGreatPerson() and plot:IsCity()) then
		-- Get the city
		local city = plot:GetPlotCity();

		-- Set the birthplace building to add based on the great person type
		local birthplaceBuilding = "";

		if(unit:GetUnitClassType() == GameInfoTypes["UNITCLASS_MERCHANT"]) then
			birthplaceBuilding = "BUILDING_GREAT_MERCHANT";
		elseif(unit:GetUnitClassType() == GameInfoTypes["UNITCLASS_SCIENTIST"]) then
			birthplaceBuilding = "BUILDING_GREAT_SCIENTIST";
		elseif(unit:GetUnitClassType() == GameInfoTypes["UNITCLASS_ENGINEER"]) then
			birthplaceBuilding = "BUILDING_GREAT_ENGINEER";
		elseif(unit:GetUnitClassType() == GameInfoTypes["UNITCLASS_ARTIST"]) then
			birthplaceBuilding = "BUILDING_GREAT_ARTIST";
		end

		-- Give the building if it doesn't already exist
		if(birthplaceBuilding ~= "" and not city:IsHasBuilding(GameInfoTypes[birthplaceBuilding])) then --and not city:IsHasBuilding(GameInfo.Buildings[GameInfoTypes[birthplaceBuilding]].ID)
			city:SetNumRealBuilding(GameInfoTypes[birthplaceBuilding], 1);

			-- If the player also has Universal Suffrage, give them the culture bonus building too
			if(player:HasPolicy(GameInfoTypes["POLICY_UNIVERSAL_SUFFRAGE"])) then
				city:SetNumRealBuilding(GameInfoTypes["BUILDING_GREAT_ARTIST_BONUS_CULTURE"], 1);
			end

			-- Send a notification to the player
			local text = Locale.ConvertTextKey("TXT_KEY_NEW_BIRTHPLACE_BUILDING", unit:GetName(), city:GetName());
			player:AddNotification(NotificationTypes.NOTIFICATION_GENERIC, text, text);
		end
	end
end
LuaEvents.SerialEventUnitCreatedGood.Add(GiveBirthPlaceBuilding);